﻿/* The code below is responsible for video controls, close button and background images. */
(function(Adf) {

    'use strict';

    var getOffset = ('getBoundingClientRect' in document.documentElement) ?
        function(elem, forceBody) {
            var box, doc = elem && elem.ownerDocument;

            if (!doc) return null;
            if (!forceBody && elem === doc.body) return bodyOffset(elem);

            try {
                box = elem.getBoundingClientRect();
            } catch (ex) {}
            if (!box) return {
                top: 0,
                left: 0
            };

            var body = doc.body,
                docElem = doc.documentElement,
                win = doc.defaultView || doc.parentWindow,
                clientTop = docElem.clientTop || body.clientTop || 0,
                clientLeft = docElem.clientLeft || body.clientLeft || 0,
                scrollTop = (docElem.scrollTop || body.scrollTop),
                scrollLeft = (docElem.scrollLeft || body.scrollLeft),
                top = box.top + scrollTop - clientTop,
                left = box.left + scrollLeft - clientLeft;

            return {
                top: top,
                left: left
            };
        } :
        function(elem) {
            var box, doc = elem && elem.ownerDocument;

            if (!doc) return null;
            if (elem === doc.body) return bodyOffset(elem);

            var computedStyle,
                offsetParent = elem.offsetParent,
                prevOffsetParent = elem,
                docElem = doc.documentElement,
                body = doc.body,
                defaultView = doc.defaultView,
                prevComputedStyle = defaultView ? defaultView.getComputedStyle(elem, null) : elem.currentStyle,
                top = elem.offsetTop,
                left = elem.offsetLeft,
                comp = _offset();

            while ((elem = elem.parentNode) && elem !== body && elem !== docElem) {
                if (comp.sfp && prevComputedStyle.position === 'fixed') {
                    break;
                }

                computedStyle = defaultView ? defaultView.getComputedStyle(elem, null) : elem.currentStyle;
                top -= elem.scrollTop;
                left -= elem.scrollLeft;

                if (elem === offsetParent) {
                    top += elem.offsetTop;
                    left += elem.offsetLeft;

                    if (comp.dnab && !(comp.dabftac && rtable.test(elem.nodeName))) {
                        top += parseFloat(computedStyle.borderTopWidth) || 0;
                        left += parseFloat(computedStyle.borderLeftWidth) || 0;
                    }

                    prevOffsetParent = offsetParent;
                    offsetParent = elem.offsetParent;
                }

                if (comp.sbfonv && computedStyle.overflow !== 'visible') {
                    top += parseFloat(computedStyle.borderTopWidth) || 0;
                    left += parseFloat(computedStyle.borderLeftWidth) || 0;
                }

                prevComputedStyle = computedStyle;
            }

            if (prevComputedStyle.position === 'relative' || prevComputedStyle.position === 'static') {
                top += body.offsetTop;
                left += body.offsetLeft;
            }

            if (comp.sfp && prevComputedStyle.position === 'fixed') {
                top += Math.max(docElem.scrollTop, body.scrollTop);
                left += Math.max(docElem.scrollLeft, body.scrollLeft);
            }

            return {
                top: top,
                left: left
            };
        };

    function offsetFromWindow(elem) {
        var box, doc, docElem, docElemOffset;

        doc = elem && elem.ownerDocument;
        if (!doc) return null;
        docElem = doc.documentElement;

        if ('getBoundingClientRect' in docElem) {
            try {
                box = elem.getBoundingClientRect();
                docElemOffset = docElem.getBoundingClientRect();
            } catch (ex) {}
            if (!box) return {
                top: 0,
                left: 0
            };

            // IE7 adds 2px on every side to document.documentElement bounding rect
            if (docElemOffset.left > 0 || docElemOffset.top > 0) {
                box.top -= docElemOffset.top;
                box.left -= docElemOffset.left;
            }

            return {
                top: box.top,
                left: box.left
            };
        } else {
            var win, body, offset, scrollTop, scrollLeft;

            win = doc.defaultView || doc.parentWindow;
            body = doc.body;

            if (elem === doc.body) return bodyOffset(elem);

            offset = getOffset(elem);
            scrollTop = (win && win.pageYOffset || docElem.scrollTop || body.scrollTop);
            scrollLeft = (win && win.pageXOffset || docElem.scrollLeft || body.scrollLeft);

            offset.top -= scrollTop;
            offset.left -= scrollLeft;

            return offset;
        }
    }

    // REUSABLE UTILITIES //

    // Set image as background of given element //
    /* SETS IMAGE AS BACKGROUND */
    function setBackgroundImage(elem, background, position, size) {
        if (elem && background) {
            elem.style.background = 'url("' + background + '") no-repeat ' + (position || '50% 50%') + ' / ' + (size || 'cover');
        }
    }

    /* REMOVES ELEMENTS WHEN IMAGE IS SET AS BACKGROUND */
    function removeElems() {
        [].forEach.call(arguments, function(id) {
            var elem = document.getElementById(id);
            elem && elem.parentNode.removeChild(elem);
        });
    }

    // REAL CUSTOM FUNCTION //
    function InView(options) {
        var _this = this;
        var pDoc = parent.document;
        var VideoPlayer = Adform.Component && Adform.Component.VideoPlayer;

        var CLOSE_MARGIN = 20, // harcoded default margins to prevent overflow issues
            CONTROLS_MARGIN = 20;

        var settings = {
            clicktag: null,
            target: null
        };

        function setup(options, settings) {
            var prop;
            var prop2;
            for (prop in options) {
                if (options.hasOwnProperty(prop)) {
                    if (!(settings[prop] instanceof HTMLElement) && settings[prop] instanceof Object) {
                        for (prop2 in options[prop]) {
                            if (options[prop].hasOwnProperty(prop2)) {
                                settings[prop][prop2] = options[prop][prop2];
                            }
                        }
                    } else {
                        settings[prop] = options[prop];
                    }
                }
            }
        }

        function addEvents() {
            if (VideoPlayer && settings.videoPlayer) {

                VideoPlayer.createPlayPause('adf-play-pause').bind(settings.videoPlayer.video.video);
                VideoPlayer.createSound('adf-sound').bind(settings.videoPlayer.video.video);
                settings.videoPlayer.video.video.addContainer('adf-video-controls');
            }

            window.parent.addEventListener('scroll', toggleControls);

            if (settings.clickArea) {
                settings.clickArea.onclick = function() {
                    window.open(settings.clicktag, settings.target);
                };
            }

            if (settings.closeButton) {
                settings.closeButton.onclick = function() {
                    window.parent.removeEventListener('scroll', toggleControls);
                    dhtml.external.close && dhtml.external.close();
                };
            }
        }

        function toggleControls() {
            var container;

            try {
                container = _AdformContent._element.parentNode;
            } catch (ex) {}

            var offsetTop = offsetFromWindow(container).top;

            var controlsOffset = (offsetTop > 0) ? offsetTop : 0;
            if (settings.closeButton) settings.closeButton.style.top = controlsOffset + CLOSE_MARGIN + 'px';
            if (settings.videoControls) settings.videoControls.style.top = controlsOffset + CONTROLS_MARGIN + 'px';
        }

        function hideCloseButton() {
            /* Hides close button set by external JS (if any) */
            try {
                pDoc.getElementById('adformOutsideCloseBtn').setAttribute('style', 'display:none!important');
            } catch (ex) {}
            /* Hides close button if in settings */
            if (settings.showClose === false && settings.closeButton) settings.closeButton.style.display = 'none';
        }

        function checkInview() {
            var inviewThreshold = settings.inview;

            if (inviewThreshold && settings.videoPlayer) {
                dhtml.inscreen.on('percent', function(value) {
                    if (value > parseInt(inviewThreshold, 10)) {
                        settings.videoPlayer.play();
                    } else {
                        settings.videoPlayer.pause();
                    }
                });
            }
        }

        function setBG() {
            if (settings.background && !(settings.videoPlayer)) {
                setBackgroundImage(settings.clickArea, settings.background, settings.backgroundPosition, settings.backgroundSize);
                removeElems('adf-video', 'adf-video-controls');
            }
        }

        this.init = function() {
            setup(options, settings);

            if (VideoPlayer && settings.videoPlayer) {
                this.AdformVideo = settings.videoPlayer;
            }

            checkInview();
            hideCloseButton();
            toggleControls();
            addEvents();
            setBG();
        };
    }

    Adf.InView = InView;

}(Adf = window.Adf || {}));